<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class TransaksiBackupController extends Controller
{
    protected $path = 'backups';

    public function __construct()
    {
        if (!File::exists(storage_path("app/{$this->path}"))) {
            File::makeDirectory(storage_path("app/{$this->path}"), 0755, true);
        }
    }

    public function simpanBackup(Request $request)
    {
        $nama = $request->input('nama_backup');
        if (!$nama || !$request->hasFile('file')) {
            return response()->json(['kode' => '0', 'pesan' => 'Nama backup atau file tidak tersedia']);
        }

        $file = $request->file('file');
        $filename = now()->format('Ymd_His') . '_' . Str::slug($nama) . '.json';
        $file->storeAs($this->path, $filename);

        // Simpan info backup (opsional bisa pakai DB juga)
        $metaFile = "{$filename}.meta.json";
        $meta = [
            'id' => pathinfo($filename, PATHINFO_FILENAME),
            'nama' => $nama,
            'file' => $filename,
            'waktu' => now()->toDateTimeString(),
        ];
        Storage::put("{$this->path}/{$metaFile}", json_encode($meta));

        return response()->json([
            'kode' => '1',
            'pesan' => 'Backup berhasil disimpan',
            'berhasil' => 1,
            'gagal' => 0
        ]);
    }

    public function daftarBackup()
    {
    $list = DB::table("backup")
        ->select("id_backup as id", "nama_backup as nama", "created_at as waktu")
        ->orderByDesc("created_at")
        ->get();

    return response()->json($list);
    }


    public function ambilBackup(Request $request)
    {
    $id_backup = $request->input('id_backup');

    if (!$id_backup) {
        return response()->json(['kode' => '0', 'pesan' => 'ID backup tidak tersedia']);
    }

    // Ambil data transaksi berdasarkan ID backup dari DB
    $data = DB::table('transaksi')
        ->where('id_backup', $id_backup)
        ->select('id_transaksi as id', 'tgl_jam', 'nominal', 'jenis', 'uraian')
        ->get();

    if ($data->isEmpty()) {
        return response()->json(['kode' => '0', 'pesan' => 'Data backup tidak ditemukan']);
    }

    return response()->json([
        'kode' => '1',
        'pesan' => 'Data backup berhasil diambil',
        'data' => $data
    ]);
}

}
