<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;
use Livewire\WithoutUrlPagination;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Hash;

class UserComponent extends Component
{
    use WithPagination,WithoutUrlPagination;
    protected $paginationTheme = 'bootstrap';
    public $nama, $email, $password, $id, $cari;
    public function render()
    {
        $layout['title'] = "Kelola User";
        if($this->cari != ""){
            $data['user'] = User::where('nama', 'like', '%' .$this->cari . '%')->orWhere('email', 'like', '%' .$this->cari . '%')->paginate(10);
        } else {
            $data['user'] = User::paginate(10);
        }
        
        return view('livewire.user-component', $data)->layoutData($layout);
    }

    public function store()
    {
        $this->validate([
            'nama' => 'required',
            'email' => 'required|email',
            'password' => 'required',
        ],[
            'nama.required' => 'Nama wajib diisi',
            'email.required' => 'Email wajib diisi',
            'email.email' => 'Email tidak valid',
            'password.required' => 'Password wajib diisi',
        ]);

        User::create([
            'nama' => $this->nama,
            'email' => $this->email,
            'password' => Hash::make($this->password),
            'jenis' => 'admin'
        ]);

        session()->flash('success', 'Behasil Disimpan !');
        $this->reset();
        $this->dispatch('modalClose'); // Livewire v3 event
    }

    public function edit($id)
    {
        $user = User::find($id);
        $this->nama = $user->nama;
        $this->email = $user->exif_thumbnail;
        $this->id = $user->id;
    }

    public function update()
    {
        $this->validate([
            'nama' => 'required',
            'email' => 'required|email',
            'password' => 'required',
        ],[
            'nama.required' => 'Nama wajib diisi',
            'email.required' => 'Email wajib diisi',
            'email.email' => 'Email tidak valid',
            'password.required' => 'Password wajib diisi',
        ]);

        $user = User::find($this->id);
        if ($this->password==""){
            $user->update([
                'nama' => $this->nama,
                'email' => $this->email
            ]);
        } else {
            $user->update([
                'nama' => $this->nama,
                'email' => $this->email,
                'password' => Hash::make($this->password)
            ]);
        }
        session()->flash('success', 'Berhasil Dirubah !');
        $this->reset();
    }

    public function confirm($id)
    {
        $this->id = $id;
    }

    public function destroy()
    {
        $user = User::find($this->id);
        $user->delete();
        session()->flash('success', 'Berhasil Dihapus !');
        $this->reset();
    }
}
