<div class="card"> <!-- Ini adalah root tunggal -->
    <div class="card-header">
        Pengembalian Buku
    </div>

    <div class="card-body">
        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">No</th>
                        <th scope="col">Buku</th>
                        <th scope="col">Member</th>
                        <th scope="col">Tanggal Pinjam</th>
                        <th scope="col">Tanggal Kembali</th>
                        <th>Proses</th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pinjam; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                            <td><?php echo e($data->buku->judul); ?></td>
                            <td><?php echo e($data->user->nama); ?></td>
                            <td><?php echo e($data->tgl_pinjam); ?></td>
                            <td><?php echo e($data->tgl_kembali); ?></td>
                            <td>
                                <a href="#" wire:click='pilih(<?php echo e($data->id); ?>)' class="btn btn-sm btn-success" data-toggle="modal" data-target="#pilih">Proses</a>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
            <?php echo e($pinjam->links()); ?>

        </div>
    </div>

    <div class="card"> <!-- Ini adalah root tunggal -->
    <div class="card-header">
        History Buku Kembali
    </div>

    <div class="card-body">
        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
            <div class="alert alert-success" role="alert">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">No</th>
                        <th scope="col">ID Pinjam</th>
                        <th scope="col">Tanggal Kembali</th>
                        <th scope="col">Denda</th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pengembalian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                            <td><?php echo e($data->pinjam_id); ?></td>
                            <td><?php echo e($data->tgl_kembali); ?></td>
                            <td><?php echo e($data->denda); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
            <?php echo e($pinjam->links()); ?>

        </div>
    </div>

    
    <div wire:ignore.self class="modal fade" id="pilih" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Form Pengembalian Buku</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row mb-3">
            <div class="col-md-4">
                Judul Buku
            </div>
            <div class="col-md-8">
                : <?php echo e($judul); ?>

            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                Member
            </div>
            <div class="col-md-8">
                : <?php echo e($member); ?>

            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                Tanggal Kembali
            </div>
            <div class="col-md-8">
                : <?php echo e($tgl_kembali); ?>

            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                Tanggal Hari Ini
            </div>
            <div class="col-md-8">
                : <?php echo e(date('Y-m-d')); ?>

            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-4">
                Denda
            </div>
            <div class="col-md-8">
                : <!--[if BLOCK]><![endif]--><?php if($this->status == true): ?>
                    Ya
                <?php else: ?>
                    Tidak
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                Terlambat
            </div>
            <div class="col-md-8">
                : <?php echo e($lama); ?> Hari
            </div>
        </div>
        
        <div class="row mb-3">
            <div class="col-md-4">
                Jumlah Denda
            </div>
            <div class="col-md-8">
                : <?php echo e($lama * 1000); ?> Rp.
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" wire:click="store" class="btn btn-primary">Save</button>
      </div>
    </div>
  </div>
</div>

</div>
<?php /**PATH C:\laragon\www\perpustakaan\resources\views/livewire/kembali-component.blade.php ENDPATH**/ ?>