<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
        <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo e($title ?? 'Page Title'); ?></title>
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin-dashboard.css')); ?>">
        <style>
            .sidebar {
                position: fixed;
                top: 0;
                bottom: 0;
                left: 0;
                z-index: 100;
                padding: 0;
                width: 250px;
                background-color: #343a40;
                overflow-x: hidden;
                overflow-y: auto;
                transition: transform 0.3s ease-in-out;
            }

            .sidebar.closed {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 250px;
                transition: margin-left 0.3s ease-in-out;
            }

            .main-content.full-width {
                margin-left: 0;
            }

            @media (max-width: 768px) {
                .sidebar {
                    transform: translateX(-100%);
                }

                .sidebar.open {
                    transform: translateX(0);
                }

                .main-content {
                    margin-left: 0;
                }
            }

            .menu-toggle {
                position: absolute;
                top: 10px;
                left: 10px;
                z-index: 101;
            }
        </style>
    </head>

    <body>
        <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php echo $__env->make('components.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Main Content -->
            <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4 main-content">
                <?php echo $__env->make('components.layouts.navigasi', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <?php echo e($slot); ?>

                
            </main>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script>
        feather.replace();

        document.querySelector('.menu-toggle').addEventListener('click', function () {
            document.querySelector('.sidebar').classList.toggle('open');
        });
    </script>

    </body>
</html>
<?php /**PATH C:\laragon\www\perpustakaan\resources\views/components/layouts/app.blade.php ENDPATH**/ ?>