<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h1 class="text-3xl font-extrabold text-gray-900 tracking-tight">Tambah Produk Baru</h1>
                    <p class="mt-2 text-sm text-gray-600">Isi informasi lengkap produk yang akan dijual.</p>
                </div>
                <a href="{{ route('admin.products') }}" class="group flex items-center px-4 py-2 bg-gray-200 text-gray-800 text-sm font-bold rounded-lg hover:bg-gray-300 transition-colors duration-200 shadow-sm">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 text-gray-500 group-hover:text-gray-700 transition-colors duration-200" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                    </svg>
                    Kembali
                </a>
            </div>

            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <div class="p-8 sm:p-10">
                    <form action="{{ route('products.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
                        @csrf

                        <div>
                            <label for="name" class="block text-sm font-bold text-gray-900 mb-2">Nama Produk</label>
                            <div class="mt-1">
                                <input type="text" name="name" id="name" required
                                       class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 placeholder-gray-400 sm:text-sm transition duration-200 font-medium"
                                       placeholder="Contoh: Laptop Gaming RTX 4060">
                            </div>
                            <p class="mt-2 text-xs text-gray-500">Gunakan nama yang jelas dan menarik.</p>
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-gray-900 mb-2">Foto Produk</label>
                            <input type="file" name="image" accept="image/*" required
                                   class="block w-full text-sm text-gray-500
                                          file:mr-4 file:py-2.5 file:px-4
                                          file:rounded-full file:border-0
                                          file:text-sm file:font-bold
                                          file:bg-indigo-50 file:text-indigo-700
                                          hover:file:bg-indigo-100
                                          cursor-pointer border border-gray-300 rounded-xl p-2">
                            <p class="mt-1 text-xs text-gray-500">Format: JPG, PNG. Maksimal 2MB.</p>
                        </div>

                        <div class="grid grid-cols-1 gap-y-8 gap-x-6 sm:grid-cols-2">
                            
                            <div>
                                <label for="price" class="block text-sm font-bold text-gray-900 mb-2">Harga Jual</label>
                                <div class="relative rounded-xl shadow-sm">
                                    <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
                                        <span class="text-gray-500 font-bold sm:text-sm">Rp</span>
                                    </div>
                                    <input type="number" name="price" id="price" required min="0"
                                           class="block w-full rounded-xl border-gray-300 pl-12 pr-4 py-3 text-gray-900 focus:border-indigo-500 focus:ring-indigo-500 placeholder-gray-400 sm:text-sm font-semibold transition duration-200"
                                           placeholder="0">
                                </div>
                            </div>

                            <div>
                                <label for="stock" class="block text-sm font-bold text-gray-900 mb-2">Stok Awal</label>
                                <div class="mt-1">
                                    <input type="number" name="stock" id="stock" required min="0"
                                           class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 placeholder-gray-400 sm:text-sm font-medium transition duration-200"
                                           placeholder="Jumlah stok tersedia">
                                </div>
                            </div>
                        </div>

                        <div>
                            <label for="description" class="block text-sm font-bold text-gray-900 mb-2">Deskripsi Produk</label>
                            <div class="mt-1">
                                <textarea id="description" name="description" rows="5" required
                                          class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 placeholder-gray-400 sm:text-sm transition duration-200"
                                          placeholder="Jelaskan fitur utama, spesifikasi, dan keunggulan produk ini..."></textarea>
                            </div>
                            <p class="mt-2 text-xs text-gray-500">Deskripsi yang detail membantu pembeli memahami produk.</p>
                        </div>

                        <div class="pt-6 border-t border-gray-100 flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.products') }}" class="px-6 py-3 bg-white text-sm font-bold text-gray-700 rounded-xl border border-gray-300 hover:bg-gray-50 hover:text-gray-900 transition focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Batal
                            </a>
                            <button type="submit" class="px-8 py-3 bg-indigo-600 text-sm font-bold text-white rounded-xl shadow-lg hover:bg-indigo-700 hover:shadow-xl transition focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transform hover:-translate-y-0.5">
                                Simpan Produk
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>