<x-app-layout>
    <head>
        {{-- Load Font & SweetAlert --}}
        <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700;900&family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <style>
            .font-gaming { font-family: 'Orbitron', sans-serif; }
            .font-sans { font-family: 'Inter', sans-serif; }
            
            /* Background Grid */
            .bg-grid-pattern {
                background-image: linear-gradient(to right, #ffffff05 1px, transparent 1px),
                                  linear-gradient(to bottom, #ffffff05 1px, transparent 1px);
                background-size: 30px 30px;
            }
            
            /* Custom Scrollbar */
            .custom-scroll::-webkit-scrollbar { height: 8px; width: 8px; }
            .custom-scroll::-webkit-scrollbar-track { background: #1e1e1e; }
            .custom-scroll::-webkit-scrollbar-thumb { background: #333; border-radius: 4px; }
            .custom-scroll::-webkit-scrollbar-thumb:hover { background: #ff7300; }
        </style>
    </head>

    <div class="min-h-screen bg-[#0a0a0a] text-white font-sans py-12 relative overflow-hidden">
        {{-- Background Decoration --}}
        <div class="absolute inset-0 bg-grid-pattern pointer-events-none"></div>
        <div class="absolute top-0 right-0 w-[400px] h-[400px] bg-[#ff7300]/5 rounded-full blur-[100px] pointer-events-none"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            
            {{-- HEADER SECTION (DIPERBAIKI) --}}
            <div class="flex flex-col md:flex-row justify-between items-center mb-10 pb-6 border-b border-gray-800 gap-6">
                
                {{-- Bagian Kiri: Judul & Deskripsi --}}
                <div class="flex items-start gap-4">
                    {{-- Ikon Dekorasi --}}
                    <div class="p-3 bg-[#1e1e1e] rounded-xl border border-gray-700 shadow-lg hidden md:block">
                        <svg class="w-8 h-8 text-[#ff7300]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path></svg>
                    </div>
                    <div>
                        <h1 class="text-3xl font-black font-gaming text-white tracking-wide">
                            MANAJEMEN PRODUK
                        </h1>
                        <p class="text-gray-400 text-sm mt-2 leading-relaxed">
                            Kelola inventory, harga, dan stok barang toko Anda di sini.
                        </p>
                    </div>
                </div>

                {{-- Bagian Kanan: Tombol Solid (DIPERBAIKI) --}}
                <a href="{{ route('products.create') }}" class="flex items-center gap-3 px-6 py-3 bg-[#ff7300] hover:bg-[#e66000] text-white font-bold rounded-lg shadow-lg hover:shadow-orange-500/30 transform hover:-translate-y-1 transition-all duration-200">
                    <div class="bg-white/20 p-1 rounded">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <span>TAMBAH ITEM</span>
                </a>
            </div>

            {{-- NOTIFIKASI TOAST (SWEETALERT) --}}
            @if(session('success'))
                <script>
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: "{{ session('success') }}",
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        background: '#1e1e1e',
                        color: '#fff',
                        iconColor: '#22c55e'
                    });
                </script>
            @endif

            @if(session('error'))
                <script>
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: "{{ session('error') }}",
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 4000,
                        background: '#1e1e1e',
                        color: '#fff',
                        iconColor: '#ef4444'
                    });
                </script>
            @endif

            {{-- TABEL PRODUK --}}
            <div class="bg-[#121212] rounded-2xl border border-gray-800 shadow-2xl overflow-hidden backdrop-blur-sm">
                <div class="overflow-x-auto custom-scroll">
                    <table class="w-full text-left align-middle">
                        <thead class="bg-[#1e1e1e] border-b border-gray-700/50">
                            <tr>
                                <th class="px-6 py-5 text-xs font-bold text-[#ff7300] uppercase tracking-wider">Info Produk</th>
                                <th class="px-6 py-5 text-xs font-bold text-gray-400 uppercase tracking-wider">Harga</th>
                                <th class="px-6 py-5 text-xs font-bold text-gray-400 uppercase tracking-wider">Stok</th>
                                <th class="px-6 py-5 text-center text-xs font-bold text-gray-400 uppercase tracking-wider">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-800">
                            @foreach($products as $product)
                            <tr class="hover:bg-white/[0.02] transition duration-200 group">
                                
                                {{-- Kolom 1: Gambar + Nama + Deskripsi --}}
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-4">
                                        <div class="h-16 w-16 flex-shrink-0 bg-[#252525] rounded-lg border border-gray-700 flex items-center justify-center overflow-hidden">
                                            @if($product->image)
                                                <img src="{{ url('gambar/' . $product->image) }}" alt="{{ $product->name }}" class="h-full w-full object-cover">
                                            @else
                                                <svg class="w-8 h-8 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                            @endif
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-white group-hover:text-[#ff7300] transition duration-300">{{ $product->name }}</div>
                                            <div class="text-xs text-gray-500 mt-1 line-clamp-1 max-w-xs">{{ $product->description }}</div>
                                        </div>
                                    </div>
                                </td>

                                {{-- Kolom 2: Harga --}}
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-bold font-gaming text-gray-300">
                                        Rp {{ number_format($product->price, 0, ',', '.') }}
                                    </span>
                                </td>

                                {{-- Kolom 3: Stok --}}
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($product->stock > 0)
                                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full bg-green-500/10 text-green-400 border border-green-500/30 shadow-[0_0_10px_rgba(34,197,94,0.2)]">
                                            {{ $product->stock }} Unit
                                        </span>
                                    @else
                                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full bg-red-500/10 text-red-400 border border-red-500/30 shadow-[0_0_10px_rgba(239,68,68,0.2)]">
                                            Habis
                                        </span>
                                    @endif
                                </td>

                                {{-- Kolom 4: Aksi --}}
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <div class="flex justify-center gap-3">
                                        {{-- Tombol Edit --}}
                                        <a href="{{ route('products.edit', $product->id) }}" class="p-2 bg-blue-500/10 text-blue-400 hover:bg-blue-500 hover:text-white rounded-lg transition-all duration-300 border border-blue-500/30 hover:shadow-[0_0_15px_rgba(59,130,246,0.5)]" title="Edit Produk">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                                        </a>
                                        
                                        {{-- Tombol Hapus --}}
                                        <form action="{{ route('products.destroy', $product->id) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus produk ini?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="p-2 bg-red-500/10 text-red-400 hover:bg-red-500 hover:text-white rounded-lg transition-all duration-300 border border-red-500/30 hover:shadow-[0_0_15px_rgba(239,68,68,0.5)]" title="Hapus Produk">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>