<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="csrf-token" content="{{ csrf_token() }}">
<title>UNWAHA Gaming Store</title>

@vite(['resources/css/app.css', 'resources/js/app.js'])

<style>
    /* RESET & FONT */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body { font-family: 'Figtree', sans-serif; color: white; overflow-x: hidden; }

    /* BACKGROUND */
    .gaming-bg {
        min-height: 100vh;
        background: radial-gradient(circle at top, #1a1a1a, #000);
    }

    /* ================= NAVBAR ================= */
    .navbar {
        height: 70px;
        background: rgba(10, 10, 10, 0.95);
        backdrop-filter: blur(10px);
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 0 20px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .nav-left { display: flex; align-items: center; gap: 15px; }
    .toggle-btn { cursor: pointer; color: #fff; transition: 0.3s; }
    .toggle-btn:hover { color: #ff004c; }
    .logo { font-weight: 900; letter-spacing: 2px; font-size: 1.2rem; background: linear-gradient(to right, #fff, #aaa); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }

    /* Search */
    .nav-search {
        flex: 1;
        max-width: 400px;
        margin: 0 20px;
        position: relative;
    }
    .nav-search input {
        width: 100%;
        padding: 10px 40px 10px 15px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 50px;
        color: white;
        outline: none;
        transition: 0.3s;
    }
    .nav-search input:focus { border-color: #ff7300; background: rgba(0, 0, 0, 0.5); }
    .nav-search .search-icon {
        position: absolute; right: 15px; top: 50%; transform: translateY(-50%); color: #888; pointer-events: none;
    }

    /* Right Nav */
    .nav-right { display: flex; align-items: center; gap: 20px; }
    
    .icon-btn {
        position: relative; color: #ccc; text-decoration: none; transition: 0.3s;
        display: flex; align-items: center; justify-content: center; padding: 8px; border-radius: 50%;
    }
    .icon-btn:hover { color: white; background: rgba(255,255,255,0.1); }
    .badge {
        position: absolute; top: 0px; right: 0px; background: #ff004c; color: white;
        font-size: 0.6rem; padding: 2px 5px; border-radius: 10px; font-weight: bold;
    }

    /* Profile Pill */
    .profile-container { position: relative; }
    .profile-pill {
        display: flex; align-items: center; gap: 10px; background: rgba(255, 255, 255, 0.05);
        padding: 5px 15px 5px 5px; border-radius: 50px; border: 1px solid rgba(255, 255, 255, 0.1);
        cursor: pointer; transition: 0.3s; user-select: none;
    }
    .profile-pill:hover { background: rgba(255, 255, 255, 0.1); border-color: #ff7300; }
    .avatar {
        width: 35px; height: 35px; border-radius: 50%; background: linear-gradient(135deg, #ff004c, #ff7300);
        display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 14px; border: 2px solid #fff;
    }
    .user-info { display: flex; flex-direction: column; line-height: 1.2; text-align: left; }
    .user-name { font-size: 0.9rem; font-weight: 600; }
    .user-role { font-size: 0.65rem; color: #aaa; text-transform: uppercase; letter-spacing: 1px; }

    /* Dropdown */
    .profile-dropdown {
        position: absolute; top: 55px; right: 0; width: 200px; background: #1e1e1e;
        border: 1px solid #333; border-radius: 12px; box-shadow: 0 10px 30px rgba(0,0,0,0.5);
        display: none; flex-direction: column; overflow: hidden; z-index: 200;
    }
    .profile-dropdown.active { display: flex; animation: slideDown 0.2s ease; }
    .dropdown-item {
        padding: 12px 15px; color: #ccc; text-decoration: none; font-size: 0.9rem;
        display: flex; align-items: center; gap: 10px; transition: 0.2s; background: transparent; border: none; width: 100%; text-align: left; cursor: pointer;
    }
    .dropdown-item:hover { background: rgba(255,255,255,0.1); color: white; }
    .dropdown-item.logout { color: #ff004c; font-weight: bold; border-top: 1px solid #333; }
    .dropdown-item.logout:hover { background: rgba(255, 0, 76, 0.1); }
    @keyframes slideDown { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }

    /* ================= LAYOUT ================= */
    .layout { display: flex; min-height: calc(100vh - 70px); }

    .sidebar {
        width: 260px; background: rgba(15, 15, 15, 0.95); padding: 20px 15px;
        display: flex; flex-direction: column; gap: 10px; transition: 0.3s ease; border-right: 1px solid rgba(255, 255, 255, 0.05);
    }
    .sidebar.collapsed { width: 70px; }
    .sidebar.collapsed a span, .sidebar.collapsed .sidebar-title { display: none; }
    .sidebar-title { font-size: 0.75rem; color: #666; text-transform: uppercase; margin-bottom: 5px; letter-spacing: 1px; padding-left: 10px; }
    .sidebar a {
        display: flex; align-items: center; gap: 12px; padding: 12px 14px;
        color: #ccc; text-decoration: none; border-radius: 10px; transition: 0.3s ease; position: relative; overflow: hidden;
    }
    .sidebar a:hover { color: white; background: rgba(255, 255, 255, 0.05); }
    .sidebar a.active { background: linear-gradient(135deg, rgba(255, 0, 76, 0.2), rgba(255, 115, 0, 0.2)); color: #ff7300; border: 1px solid rgba(255, 115, 0, 0.3); }
    .sidebar a.active::before { content: ""; position: absolute; left: 0; top: 0; height: 100%; width: 4px; background: #ff7300; box-shadow: 0 0 10px #ff7300; }
    
    .nav-icon { width: 20px; height: 20px; stroke-width: 2; }
    .main-content { flex: 1; padding: 25px; overflow-y: auto; }
    .glass { background: rgba(255, 255, 255, 0.03); backdrop-filter: blur(5px); padding: 20px; border-radius: 14px; border: 1px solid rgba(255, 255, 255, 0.05); margin-bottom: 20px; }
    .card { background: #1e1e1e; padding: 25px; border-radius: 14px; border: 1px solid #333; }

    @media (max-width: 768px) {
        .nav-search, .user-info { display: none; } 
        .sidebar { position: fixed; left: -260px; top: 70px; height: calc(100vh - 70px); z-index: 99; }
        .sidebar.show { left: 0; }
    }
</style>
</head>

<body>
<div class="gaming-bg">

    <header class="navbar">
        <div class="nav-left">
            <div class="toggle-btn" onclick="toggleSidebar()">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"></path></svg>
            </div>
            <h2 class="logo">UNWAHA <span style="color:#ff7300">STORE</span></h2>
        </div>

        <div class="nav-search">
            <input type="text" placeholder="Cari game, item, atau voucher...">
            <div class="search-icon">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
            </div>
        </div>

        <div class="nav-right">
            @auth
                @php $cartCount = \App\Models\Cart::where('user_id', Auth::id())->count(); @endphp

                <a href="{{ route('cart.index') }}" class="icon-btn" title="Keranjang">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                    @if($cartCount > 0) <span class="badge">{{ $cartCount }}</span> @endif
                </a>
                
                {{-- ? IKON LACAK & LONCENG SUDAH DIHAPUS --}}
            @endauth

            @auth
            <div class="profile-container">
                <div class="profile-pill" onclick="toggleProfileMenu()">
                    <div class="avatar">{{ substr(Auth::user()->name, 0, 1) }}</div>
                    <div class="user-info">
                        <span class="user-name">{{ Auth::user()->name }}</span>
                        <span class="user-role">{{ Auth::user()->role ?? 'Gamer' }}</span>
                    </div>
                    <svg style="width:12px; margin-left:5px; color:#888" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </div>

                <div class="profile-dropdown" id="profileDropdown">
                    <a href="{{ route('profile.edit') }}" class="dropdown-item">
                        <svg class="nav-icon" style="width:16px; margin-right:8px;" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                        Profile Saya
                    </a>
                    <form method="POST" action="{{ route('logout') }}" style="width: 100%;">
   						 @csrf  <button type="submit" class="dropdown-item logout">
        					<svg class="nav-icon" style="width:16px; margin-right:8px;" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
        						Logout
   						 </button>
					</form>
                </div>
            </div>
            @endauth
        </div>
    </header>

    <div class="layout">
        @auth
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-title">MENU UTAMA</div>
            
            <a href="{{ route('dashboard') }}" class="{{ request()->routeIs('dashboard') ? 'active' : '' }}">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                <span>Dashboard</span>
            </a>

            <a href="{{ route('orders.index') }}" class="{{ request()->routeIs('orders.index') ? 'active' : '' }}">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path></svg>
                <span>Pesanan Saya</span>
            </a>

            @if(Auth::user()->role === 'admin')
            <div class="sidebar-title" style="margin-top:15px">ADMINISTRATOR</div>
            <a href="{{ route('admin.products') }}" class="{{ request()->routeIs('admin.products') ? 'active' : '' }}">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path></svg>
                <span>Kelola Produk</span>
            </a>
            <a href="{{ route('admin.orders') }}" class="{{ request()->routeIs('admin.orders') ? 'active' : '' }}">
                <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path></svg>
                <span>Kelola Pesanan</span>
            </a>
            @endif
        </aside>
        @endauth

        <main class="main-content">
            @isset($header)
                <div class="glass"><h3 style="font-size: 1.5rem; font-weight: bold; color: #ff7300;">{{ $header }}</h3></div>
            @endisset
            <div class="card">{{ $slot ?? ($content ?? '') }}</div>
        </main>
    </div>
</div>

<script>
    function toggleSidebar(){
        const sb = document.getElementById('sidebar');
        if(window.innerWidth <= 768){ sb.classList.toggle('show'); } else { sb.classList.toggle('collapsed'); }
    }
    function toggleProfileMenu() { document.getElementById('profileDropdown').classList.toggle('active'); }
    window.onclick = function(event) {
        if (!event.target.closest('.profile-container')) {
            var dropdowns = document.getElementsByClassName("profile-dropdown");
            for (var i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('active')) { openDropdown.classList.remove('active'); }
            }
        }
    }
</script>
</body>
</html>