<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <head>
        
        <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700;900&family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <style>
            .font-gaming { font-family: 'Orbitron', sans-serif; }
            .font-sans { font-family: 'Inter', sans-serif; }
            
            /* Background Grid Pattern */
            .bg-grid-pattern {
                background-image: linear-gradient(to right, #ffffff05 1px, transparent 1px),
                                  linear-gradient(to bottom, #ffffff05 1px, transparent 1px);
                background-size: 40px 40px;
            }

            /* Animasi Berkedip untuk Stok Kritis */
            @keyframes panic-pulse {
                0%, 100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.7); border-color: rgba(239, 68, 68, 0.8); }
                50% { box-shadow: 0 0 0 10px rgba(239, 68, 68, 0); border-color: rgba(239, 68, 68, 1); }
            }
            .panic-mode {
                animation: panic-pulse 1.5s infinite;
            }
        </style>
    </head>

    <div class="min-h-screen bg-[#0a0a0a] text-white font-sans pb-20 relative">
        
        
        <div class="relative overflow-hidden bg-[#0f0f0f] border-b border-gray-800">
            <div class="absolute inset-0 bg-grid-pattern opacity-30"></div>
            <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[600px] h-[300px] bg-[#ff7300]/10 rounded-full blur-[120px] pointer-events-none"></div>

            <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 text-center">
                <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-white/5 border border-white/10 mb-6 backdrop-blur-sm">
                    <span class="w-2 h-2 rounded-full bg-[#ff7300] animate-pulse"></span>
                    <span class="text-[10px] font-bold tracking-widest text-gray-400 uppercase">Official Store</span>
                </div>
                
                <h1 class="text-4xl sm:text-6xl font-black leading-tight mb-4">
                    GAMING GEAR <br>
                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-[#ff7300] to-yellow-500 font-gaming">NEXT LEVEL</span>
                </h1>
                
                <p class="text-gray-400 text-lg mb-8 max-w-2xl mx-auto">
                    Upgrade setup-mu sekarang. Hati-hati, item langka cepat habis!
                </p>
            </div>
        </div>

        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-12">
            
            <div class="flex items-center justify-between mb-8 border-b border-gray-800 pb-4">
                <h2 class="text-2xl font-bold font-gaming text-white flex items-center gap-3">
                    <svg class="w-6 h-6 text-[#ff7300]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                    HOT ITEMS
                </h2>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                
                <div class="group relative bg-[#121212] rounded-2xl overflow-hidden transition-all duration-300 flex flex-col h-full hover:-translate-y-2 border <?php echo e($product->stock <= 3 && $product->stock > 0 ? 'border-red-500/50 panic-mode' : 'border-gray-800 hover:border-[#ff7300]'); ?>">
                    
                    
                    <div class="relative h-60 w-full p-6 bg-[#181818] flex items-center justify-center overflow-hidden group-hover:bg-[#1a1a1a] transition-colors">
                        <?php if($product->image): ?>
                            <img src="<?php echo e(url('gambar/' . $product->image)); ?>" alt="<?php echo e($product->name); ?>" class="max-h-full max-w-full object-contain transition duration-500 group-hover:scale-110 drop-shadow-lg">
                        <?php else: ?>
                            <svg class="w-16 h-16 text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                        <?php endif; ?>

                        
                        <div class="absolute top-3 right-3 z-10">
                            <?php if($product->stock == 0): ?>
                                <span class="bg-gray-800 text-gray-400 text-[10px] font-bold px-2.5 py-1 rounded-md border border-gray-600">SOLD OUT</span>
                            <?php elseif($product->stock <= 3): ?>
                                
                                <div class="flex items-center gap-1 bg-red-600 text-white text-[10px] font-bold px-3 py-1 rounded-md shadow-lg animate-pulse">
                                    <svg class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
                                    SISA <?php echo e($product->stock); ?>!
                                </div>
                            <?php else: ?>
                                <span class="bg-black/70 backdrop-blur text-white text-[10px] font-bold px-2.5 py-1 rounded-md border border-gray-600">
                                    Ready: <?php echo e($product->stock); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="p-5 flex flex-col flex-1 bg-[#121212] relative">
                        <div class="flex-1">
                            <h3 class="text-white font-bold text-base mb-1 leading-tight group-hover:text-[#ff7300] transition line-clamp-1">
                                <?php echo e($product->name); ?>

                            </h3>
                            <p class="text-gray-500 text-xs line-clamp-2 leading-relaxed mb-4">
                                <?php echo e($product->description); ?>

                            </p>
                        </div>

                        
                        <div class="flex items-center justify-between border-t border-gray-800 pt-4 mt-auto">
                            <div>
                                <p class="text-[10px] text-gray-500 uppercase tracking-wider font-semibold">Harga</p>
                                <p class="text-lg font-bold font-gaming text-[#ff7300]">
                                    Rp <?php echo e(number_format($product->price, 0, ',', '.')); ?>

                                </p>
                            </div>

                            <?php if($product->stock > 0): ?>
                                <form action="<?php echo e(route('cart.add', $product->id)); ?>" method="POST" 
                                      onsubmit="return checkStock(this, <?php echo e($product->stock); ?>)">
                                    <?php echo csrf_field(); ?>
                                    
                                    <button type="submit" class="w-10 h-10 rounded-lg flex items-center justify-center transition-all duration-300 shadow-lg active:scale-95 group-btn
                                        <?php echo e($product->stock <= 3 ? 'bg-red-600 hover:bg-red-700 text-white animate-bounce' : 'bg-white hover:bg-[#ff7300] hover:text-white text-black'); ?>">
                                        
                                        <svg class="w-5 h-5 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                    </button>
                                </form>
                            <?php else: ?>
                                <button disabled class="w-10 h-10 bg-[#1a1a1a] rounded-lg flex items-center justify-center text-gray-700 cursor-not-allowed border border-gray-800">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-full py-20 text-center">
                    <p class="text-gray-500">Belum ada produk tersedia.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <script>
        // Fungsi Cek Stok saat tombol diklik
        function checkStock(form, stock) {
            // Animasi Loading pada tombol
            let btn = form.querySelector('button');
            let originalContent = btn.innerHTML;
            btn.innerHTML = '<svg class="animate-spin w-5 h-5" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>';
            
            // Jika stok kritis (<= 3), kita biarkan submit tapi dengan perasaan was-was (hehe)
            // Sistem backend tetap akan memproses.
            // Namun, notifikasi visual di atas sudah memberikan peringatan keras.
            
            return true; // Lanjut submit form
        }

        // Notifikasi Toast (Logic Tambahan)
        document.addEventListener('DOMContentLoaded', function() {
            <?php if(session('success')): ?>
                // Cek pesan session, apakah ada kata kunci stok? (Opsional)
                // Kita gunakan default success toast tapi dengan style gelap
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: 'Berhasil Masuk Keranjang!',
                    text: "<?php echo e(session('success')); ?>",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    background: '#1e1e1e',
                    color: '#fff',
                    iconColor: '#22c55e'
                });
            <?php endif; ?>
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /home/ghazi/public_html/POS/resources/views/dashboard.blade.php ENDPATH**/ ?>