<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    
    <head>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        <script type="text/javascript"
            src="https://app.sandbox.midtrans.com/snap/snap.js"
            data-client-key="<?php echo e(config('services.midtrans.client_key')); ?>"></script>
        
        <style>
            /* Custom Animation untuk Table */
            .fade-in-up {
                animation: fadeInUp 0.8s ease-out;
            }
            @keyframes fadeInUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            .glass-effect {
                background: rgba(30, 30, 30, 0.7);
                backdrop-filter: blur(10px);
                -webkit-backdrop-filter: blur(10px);
            }
        </style>
    </head>

     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                
                <div class="p-2 bg-orange-500/20 rounded-lg mr-3 shadow-[0_0_15px_rgba(255,115,0,0.5)]">
                    <svg class="w-6 h-6 text-[#ff7300]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-white to-gray-400">
                    Riwayat Pesanan
                </h2>
            </div>
            
            <div class="text-sm text-gray-400 bg-black/30 px-4 py-2 rounded-full border border-gray-700">
                Total Transaksi: <span class="text-[#ff7300] font-bold"><?php echo e($orders->count()); ?></span>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8 fade-in-up">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            
            <div class="glass-effect border border-gray-700 overflow-hidden shadow-2xl sm:rounded-2xl relative">
                
                
                <div class="absolute top-0 right-0 -mt-10 -mr-10 w-32 h-32 bg-[#ff7300] rounded-full mix-blend-multiply filter blur-3xl opacity-10 animate-pulse"></div>

                <div class="p-6">
                    
                    <?php if(session('success')): ?>
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Berhasil!',
                                    text: "<?php echo e(session('success')); ?>",
                                    background: '#1e1e1e',
                                    color: '#fff',
                                    confirmButtonColor: '#ff7300'
                                });
                            });
                        </script>
                    <?php endif; ?>

                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead>
                                <tr class="text-xs font-bold uppercase tracking-wider text-gray-400 border-b border-gray-700 bg-black/40">
                                    <th class="px-6 py-4 rounded-tl-lg">ID Order</th>
                                    <th class="px-6 py-4">Total Pembayaran</th>
                                    <th class="px-6 py-4">Status</th>
                                    <th class="px-6 py-4">Tanggal</th>
                                    <th class="px-6 py-4 text-center rounded-tr-lg">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="text-sm divide-y divide-gray-800">
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-white/5 transition duration-300 group">
                                    
                                    <td class="px-6 py-5 font-mono text-[#ff7300] group-hover:text-white transition">
                                        #<?php echo e($order->id); ?>

                                    </td>
                                    
                                    
                                    <td class="px-6 py-5 font-bold text-lg text-gray-200">
                                        Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?>

                                    </td>

                                    
                                    <td class="px-6 py-5">
                                        <?php
                                            $statusColor = match($order->status) {
                                                'paid', 'completed' => 'bg-green-500/20 text-green-400 border-green-500/50',
                                                'pending' => 'bg-yellow-500/20 text-yellow-400 border-yellow-500/50',
                                                'shipped' => 'bg-blue-500/20 text-blue-400 border-blue-500/50',
                                                'cancelled' => 'bg-red-500/20 text-red-400 border-red-500/50',
                                                default => 'bg-gray-500/20 text-gray-400 border-gray-500/50'
                                            };
                                            
                                            $statusIcon = match($order->status) {
                                                'paid', 'completed' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                                'pending' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
                                                'shipped' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>',
                                                default => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>'
                                            };
                                        ?>

                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold border <?php echo e($statusColor); ?> shadow-sm">
                                            <svg class="w-3 h-3 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <?php echo $statusIcon; ?>

                                            </svg>
                                            <?php echo e(ucfirst($order->status)); ?>

                                        </span>
                                    </td>

                                    <td class="px-6 py-5 text-gray-400 text-xs">
                                        <div class="flex flex-col">
                                            <span><?php echo e($order->created_at->format('d M Y')); ?></span>
                                            <span class="text-gray-600"><?php echo e($order->created_at->format('H:i')); ?> WIB</span>
                                        </div>
                                    </td>

                                    
                                    <td class="px-6 py-5 text-center">
                                        <?php if($order->status == 'pending' && $order->snap_token): ?>
                                            <button onclick="pay('<?php echo e($order->snap_token); ?>', <?php echo e($order->id); ?>)" 
                                                    class="group relative inline-flex items-center justify-center px-4 py-2 overflow-hidden font-bold text-white rounded-lg shadow-lg transition-all duration-300 hover:scale-105 bg-gradient-to-br from-[#ff7300] to-[#ff4500] hover:from-[#ff4500] hover:to-[#e63e00]">
                                                <span class="relative flex items-center gap-2 text-xs">
                                                    Bayar Sekarang
                                                    <svg class="w-3 h-3 animate-bounce" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                                </span>
                                            </button>

                                        <?php elseif($order->status == 'paid'): ?>
                                            <span class="text-green-400 font-bold flex items-center justify-center gap-1 text-xs bg-green-500/10 py-1 px-3 rounded-full border border-green-500/20">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                Lunas
                                            </span>

                                        <?php elseif($order->status == 'shipped'): ?>
                                            <span class="text-blue-400 font-bold flex items-center justify-center gap-1 text-xs bg-blue-500/10 py-1 px-3 rounded-full border border-blue-500/20">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                                Dikirim
                                            </span>

                                        <?php elseif($order->status == 'completed'): ?>
                                            <span class="text-emerald-400 font-bold flex items-center justify-center gap-1 text-xs bg-emerald-500/10 py-1 px-3 rounded-full border border-emerald-500/20">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                                Selesai
                                            </span>

                                        <?php elseif($order->status == 'cancelled'): ?>
                                            <span class="text-red-400 font-bold flex items-center justify-center gap-1 text-xs bg-red-500/10 py-1 px-3 rounded-full border border-red-500/20">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                                                Batal
                                            </span>

                                        <?php else: ?>
                                            <span class="text-gray-500 text-xs italic">Menunggu</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="px-6 py-20 text-center">
                                        <div class="flex flex-col items-center justify-center">
                                            <svg class="w-16 h-16 text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                            <p class="text-gray-400 text-lg">Belum ada riwayat pesanan.</p>
                                            <a href="<?php echo e(route('dashboard')); ?>" class="mt-4 text-[#ff7300] hover:text-white transition underline">Belanja Sekarang</a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    
    <script type="text/javascript">
        function pay(snapToken, orderId) {
            // Tampilkan Loading
            Swal.fire({
                title: 'Membuka Pembayaran...',
                html: 'Mohon tunggu sebentar.',
                timer: 2000,
                timerProgressBar: true,
                background: '#1e1e1e',
                color: '#fff',
                didOpen: () => { Swal.showLoading() }
            });

            window.snap.pay(snapToken, {
                onSuccess: function(result){
                    Swal.fire({
                        icon: 'success',
                        title: 'Pembayaran Berhasil!',
                        text: 'Terima kasih telah berbelanja.',
                        background: '#1e1e1e',
                        color: '#fff',
                        confirmButtonColor: '#22c55e',
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        window.location.href = "<?php echo e(url('payment/success')); ?>/" + orderId;
                    });
                },
                onPending: function(result){
                    Swal.fire({
                        icon: 'info',
                        title: 'Menunggu Pembayaran',
                        text: 'Silakan selesaikan pembayaran Anda.',
                        background: '#1e1e1e',
                        color: '#fff',
                        confirmButtonColor: '#eab308'
                    }).then(() => { location.reload(); });
                },
                onError: function(result){
                    Swal.fire({
                        icon: 'error',
                        title: 'Pembayaran Gagal',
                        text: 'Terjadi kesalahan saat memproses pembayaran.',
                        background: '#1e1e1e',
                        color: '#fff',
                        confirmButtonColor: '#ef4444'
                    }).then(() => { location.reload(); });
                },
                onClose: function(){
                    Swal.fire({
                        title: 'Dibatalkan',
                        text: 'Anda menutup popup tanpa membayar.',
                        background: '#1e1e1e',
                        color: '#fff',
                        confirmButtonColor: '#6b7280'
                    });
                }
            });
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /home/ghazi/public_html/POS/resources/views/orders/index.blade.php ENDPATH**/ ?>