<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Semi Circle Gauge Chart</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .chart-container {
            width: 200px;
            height: 120px;
            margin: auto;
            position: relative;
            text-align: center;
        }
        .gauge-label {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 16px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <script>
        setTimeout(function() {
            location.reload(); // Refresh halaman setelah 5 detik
        }, 5000); // Waktu dalam milidetik (5 detik)
</script>
    
    <?php
        // Koneksi ke database
      include ('koneksi.php');
        
        if ($conn->connect_error) {
            die("Koneksi gagal: " . $conn->connect_error);
        }
                // Ambil nilai dari database
        $sql = "SELECT * FROM tbl_water_update WHERE no = 1";
        $result = $conn->query($sql);
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $dataValue = $row["tinggi_air"];
        } else {
            $dataValue = 0;
        }
        
        $conn->close();
    ?>
    
    <div class="chart-container">
        <div class="gauge-label" id="gaugeLabel"><?php echo $dataValue; ?>%</div>
        <canvas id="gaugeChart"></canvas>
    </div>
    
    <script>
        var ctx = document.getElementById('gaugeChart').getContext('2d');
        var dataValue = <?php echo $dataValue; ?>; // Nilai dari database
        var maxValue = 4;
        
        document.getElementById('gaugeLabel').outerText = 'Tinggi Air ' + dataValue + ' cm';
        
        var gaugeChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Progress', 'Remaining'],
                datasets: [{
                    data: [dataValue, maxValue - dataValue],
                    backgroundColor: ['#4CAF50', '#E0E0E0'],
                    borderWidth: 0,
                }]
            },
            options: {
                rotation: -90,
                circumference: 180,
                cutout: '80%',
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    </script>
</body>
</html>
    