<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>UNWAHA Gaming Store</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,700,900&display=swap" rel="stylesheet" />

    @vite(['resources/css/app.css'])
    <link rel="stylesheet" href="{{ asset('css/gaming.css') }}">
</head>

<body class="gaming-bg">

<div class="min-h-screen flex flex-col items-center justify-center relative px-4">

    <!-- BRANDING HEADER (TIDAK BLUR) -->
    <div class="relative z-20 text-center mb-10">
        <h1 class="text-4xl md:text-5xl font-black tracking-tight text-cyan-300">
            UNWAHA GAMING STORE
        </h1>
    </div>

    <!-- LOGIN CARD (TETAP) -->
    <div class="relative z-20 w-full max-w-md glass card">
        {{ $slot }}
    </div>

</div>

<!-- FOOTER (TETAP) -->
<footer class="absolute bottom-4 w-full text-center text-xs text-gray-400 z-20">
    © {{ date('Y') }} UNWAHA Gaming Store. All rights reserved.
</footer>

</body>
</html>
