<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="text-2xl font-bold text-white leading-tight">
            📦 Kelola Pesanan
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            
            <div class="bg-[#1e1e1e] border border-gray-700 overflow-hidden shadow-xl sm:rounded-2xl">
                <div class="p-6 text-gray-100">
                    
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead>
                                <tr class="text-xs font-bold uppercase tracking-wider text-gray-400 border-b border-gray-700 bg-black/20">
                                    <th class="px-6 py-4">ID Order</th>
                                    <th class="px-6 py-4">Pembeli</th>
                                    <th class="px-6 py-4">Total</th>
                                    <th class="px-6 py-4">Status Saat Ini</th>
                                    <th class="px-6 py-4">Tanggal</th>
                                    <th class="px-6 py-4 text-center">Aksi (Ubah)</th>
                                </tr>
                            </thead>
                            <tbody class="text-sm divide-y divide-gray-800">
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-white/5 transition duration-150">
                                    
                                    <td class="px-6 py-4 font-mono text-[#ff7300] font-bold">
                                        #<?php echo e($order->id); ?>

                                    </td>
                                    
                                    
                                    <td class="px-6 py-4">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 rounded-full bg-gradient-to-r from-blue-600 to-purple-600 flex items-center justify-center font-bold text-xs shadow-lg">
                                                <?php echo e(substr($order->user->name, 0, 1)); ?>

                                            </div>
                                            <span class="font-medium text-gray-300"><?php echo e($order->user->name); ?></span>
                                        </div>
                                    </td>

                                    
                                    <td class="px-6 py-4 font-bold text-white">
                                        Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?>

                                    </td>

                                    
                                    <td class="px-6 py-4">
                                        <?php
                                            $statusColors = [
                                                'pending'   => 'bg-yellow-500/10 text-yellow-500 border-yellow-500/20',
                                                'paid'      => 'bg-green-500/10 text-green-500 border-green-500/20',
                                                'shipped'   => 'bg-blue-500/10 text-blue-500 border-blue-500/20',
                                                'completed' => 'bg-purple-500/10 text-purple-500 border-purple-500/20',
                                                'cancelled' => 'bg-red-500/10 text-red-500 border-red-500/20',
                                            ];
                                            $class = $statusColors[$order->status] ?? 'bg-gray-500/10 text-gray-500';
                                        ?>
                                        <span class="px-3 py-1 rounded-full text-xs font-bold border <?php echo e($class); ?>">
                                            <?php echo e(ucfirst($order->status)); ?>

                                        </span>
                                    </td>

                                    
                                    <td class="px-6 py-4 text-gray-500 text-xs">
                                        <?php echo e($order->created_at->format('d M Y, H:i')); ?>

                                    </td>

                                    
                                    <td class="px-6 py-4">
                                        <form action="<?php echo e(route('admin.orders.update', $order->id)); ?>" method="POST" class="flex items-center justify-center gap-2">
                                            <?php echo csrf_field(); ?>
                                            
                                            
                                            <?php echo method_field('PUT'); ?> 
                                            
                                            <div class="relative group w-full">
                                                
                                                <select name="status" 
                                                        onchange="this.form.submit()"
                                                        class="w-full appearance-none cursor-pointer bg-[#2a2a2a] text-white border border-gray-600 rounded-lg py-2 pl-3 pr-8 text-xs font-bold focus:outline-none focus:ring-2 focus:ring-[#ff7300] focus:border-transparent hover:border-[#ff7300] transition-all shadow-sm">
                                                    
                                                    
                                                    <option value="pending" class="bg-[#1e1e1e] text-yellow-500" <?php echo e($order->status == 'pending' ? 'selected' : ''); ?>>⏳ Pending</option>
                                                    <option value="paid" class="bg-[#1e1e1e] text-green-500" <?php echo e($order->status == 'paid' ? 'selected' : ''); ?>>💸 Paid (Lunas)</option>
                                                    <option value="shipped" class="bg-[#1e1e1e] text-blue-500" <?php echo e($order->status == 'shipped' ? 'selected' : ''); ?>>🚚 Shipped (Dikirim)</option>
                                                    <option value="completed" class="bg-[#1e1e1e] text-purple-500" <?php echo e($order->status == 'completed' ? 'selected' : ''); ?>>✅ Completed (Selesai)</option>
                                                    <option value="cancelled" class="bg-[#1e1e1e] text-red-500" <?php echo e($order->status == 'cancelled' ? 'selected' : ''); ?>>❌ Cancelled (Batal)</option>
                                                </select>
                                                
                                                
                                                <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-400">
                                                    <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/></svg>
                                                </div>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="px-6 py-12 text-center">
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <svg class="w-12 h-12 mb-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg>
                                            <span class="text-sm">Belum ada pesanan masuk.</span>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /home/ghazi/public_html/POS/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>