<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('backups', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('file_name');
            $table->timestamps();
        });

        Schema::create('transaksi', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->string('tgl_jam');
            $table->decimal('nominal', 15, 2);
            $table->string('jenis', 1); // '+' atau '-'
            $table->string('uraian');
            $table->index('tgl_jam');
        });
    }

    public function down()
    {
        Schema::dropIfExists('backups');
        Schema::dropIfExists('transaksi');
    }
};